
;    NOM:   					ESCLAVE pour AFFICHEUR	 LCD GRAPHIQUE    
;    Date:    02/03/2004                		^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^                  
;    Version:  1.0                                                            
;    						               
;	TYPE d'AFFICHEUR	  	TLX1741 C3M	240*128 pixels  	8k ram dual-scan	     
;	MODE  TEXTE		driver "T6963C Toshiba"	             
;				             	*********************
;
;				simulation mode I2C_simul
;							     		
;                                                       		
;*****************************************************************************
;    Fichier requis: P16F876.inc                                             
;*****************************************************************************
 
	LIST      P=16F876            ; Dfinition de processeur
	#include <p16F876.inc>        ; fichier include
	
;#DEFINE SIMMODE

	ERRORLEVEL -302, -224 ,-202

	__CONFIG   _CP_OFF & _DEBUG_OFF & _WRT_ENABLE_OFF & _CPD_OFF & _LVP_OFF & _BODEN_OFF & _PWRTE_ON & _WDT_OFF & _HS_OSC

		;_CP_OFF				Pas de protection
		;_DEBUG_OFF			RB6 et RB7 en utilisation normale
		;_WRT_ENABLE_OFF	Le programme ne peut pas crire dans la flash
		;_CPD_OFF              	Mmoire EEprom dprotge
		;_LVP_OFF			RB3 en utilisation normale
		; _BODEN_OFF			Reset tension hors service
		;_PWRTE_ON			Dmarrage temporis
		;_WDT_OFF			Watchdog hors service
		;_HS_OSC				Oscillateur haute vitesse (4Mhz<F<20Mhz)

;*****************************************************************************
;                      VARIABLES ZONE COMMUNE                                *
;*****************************************************************************

; Zone de 16 bytes
; ----------------

	CBLOCK 0x70		; Dbut de la zone (0x70  0x7F)

cmpt_TIMER_0		:1			; compteur timer 0

w_temp 			: 1			; Sauvegarde registre W
status_temp 		: 1			; sauvegarde registre STATUS
FSR_temp 			: 1			; sauvegarde de FSR pour interrupt
PCLATH_temp 	: 1			; sauvegarde de PCLATH pour interrupt
EEDATA2			:1
TEMP		:1
result				:1
FLAG_ADRESSE_ok				:1

	ENDC

;*****************************************************************************
;                               ASSIGNATIONS SYSTEME                         *
;*****************************************************************************

; REGISTRE OPTION_REG (configuration)
; -----------------------------------
OPTIONVAL	EQU	B'10000111'  ; Rsistances rappel +5V hors service

					;bit 5   T0CS  =0		: Fonctionnement en mode timer
					;bit6    INTEDG   		  les interruptions sur RB0
								;Si b6 = 0,l'interruption s'effectuera lors de la transition de 1 vers 0.
								
				; INTEDG b6	 : 1= Interrupt sur flanc montant de RB0
							; 0= Interrupt sur flanc descend. de RB0	
								
					;bit2    PS2
					;bit1    PS1
					;bit0    PS0
										;	 Prscaler timer  256

; REGISTRE INTCON (controle interruptions standard)
; -------------------------------------------------
INTCONVAL	EQU	B'01000000'  ; autorisation gnrale priphriques
							;RB0 		ON
							;TMR0 		ON
					; GIE   b7 : masque autorisation gnrale interrupt 
								; ne pas mettre ce bit  1 ici ; sera mis en temps utile 
					; PEIE b6 : masque autorisation gnrale priphriques 
					; T0IE  b5 : masque interruption tmr0 
					; INTE b4 : masque interruption RB0/Int 
					; RBIE b3 : masque interruption RB4/RB7 
								; Valide les interruptions si on a changement de niveau sur une des entres RB4  RB7.
					; T0IF  b2 : flag tmr0 
					; INTF b1 : flag RB0/Int 
					; RBIF b0 : flag interruption RB4/RB7


; REGISTRE PIE1 (contrle interruptions priphriques)
; ----------------------------------------------------
PIE1VAL		EQU	B'00000000'  ; 
				 
					; PSPIE	b7  	: Toujours 0 sur PIC 16F786 
					; ADIE		b6   : masque interrupt convertisseur A/D 
					; RCIE		b5   : masque interrupt rception USART 
					; TXIE		b4   : masque interrupt transmission USART 
					; SSPIE		b3  	: masque interrupt port srie synchrone 
					; CCP1IE	b2 	: masque interrupt CCP1 
					; TMR2IE	b1 	: masque interrupt TMR2 = PR2 
					; TMR1IE	b0 	: masque interrupt dbordement tmr1
			
			
;LCD_ADRVAL		EQU 0xAA

;***** Ram Init
;DebutRamInit	EQU	0x20		; Debut de la RAM pour initialisation
;FinRamInit	EQU	0x7F		; FIN de la RAM pour initialisation

;////////////////////////////////////////////////////////////////////////////

;  Brochage du PIC sur la carte :
;
;  Port | Broche | E/S | Nom             	| Description
 
;  RA0  |    02  |  S  |   OPTIONNEL	  	 |	SIMULATION I2C SDA         ESCLAVE    =>    vers le SAA1064   ou autre	         
;  RA1  |    03  |  S  |	  OPTIONNEL	  	 | 	SIMULATION  I2C  SCL        ESCLAVE    =>    vers le SAA1064   ou autre

;  RA2  |    04  |  S  | 		 		| 
;  RA3  |    05  |  S  | 				|  
;  RA4  |    06  |  S  | 				|  
;  RA5  |    07  |  S  |		             		| 

;  RB0  |    21  |  S |  SDA	     			| SIMULATION  I2C  SDA         DATAS IN du maitre	 
;  RB1  |    22  |  S   |  SCL    			| SIMULATION  I2C  SCL          CLOCK IN du maitre
									
;  RB2  |    23  |  S  |    RV   			| REVERSE	 	 	  
;  RB3  |    24  |  S  | FS      			| FONT SELECT

;  RB4  |    25  | /E | C/D  	 			| COMMANDE  /   DATA		 	
;  RB5  |    26  | /E |  CE       			|CHIP ENABLE
;  RB6  |    27  | /E | 	 RD				| DATA READ
;  RB7  |    28  | /E |   WR	 			| DATA WRITE  

;  RC0  |    11  |  S  	| D0 				|  	BUS DE DATAs  LCD
;  RC1  |    12  |  S  	| D1 				|  
;  RC2  |    13  | S 	| D2 	      		 	|	 
;  RC3  |    14  | S	| D3      			|  
;  RC4  |    15  | S  	| D4 				|  
;  RC5  |    16  |  S  	| D5				|  
;  RC6  |    17  |  S  	| D6 				| 
;  RC7  |    18  |  S 	| D7 				| 


;////////////////////////////////////////////////////////////////////////////



;////////////////////////////////////////////////////////////////////////////
;		Register declarations
;////////////////////////////////////////////////////////////////////////////

	
COMMANDE_I2C		EQU PORTB
 



;////////////////////////////////////////////////////////////////////////////
;		Literal declarations
;////////////////////////////////////////////////////////////////////////////

	; PORTA control bits



	; PORTB control bits
_SDA 	EQU	0 ; _SDA  sur RB0/INT	
_SCL 	EQU	1 ; _SCL  sur RB1

	; PORTC control bits
 


;*****************************************************************************
;                           ASSIGNATIONS PROGRAMME                           *
;*****************************************************************************

; pour des fontes de 8*8 cela nous donne 240/8 =30 soit 1EH
; pour des fontes de 6*8 cela nous donne 240/6 =40 soit 28H

;ici nous sommes en dual-screen (c.f datasheet pour 8 k ram) 

; pour des fontes de 6*8 cela nous donne 2BH
; pour des fontes de 8*8 cela nous donne 20H 

G_HOME		EQU	0x0020		; adresse mmoire graphique
			;Upper half screen  Graphic Ram Area (0000H - 07FFH : 2048 bytes) 
			;Lower half screen  Graphic Ram Area (8000H - 87FFH: 2048 bytes) 
			
G_AREA		EQU	0x002B		; 40 colonnes graphiques


T_HOME		EQU	0x0000		; adresse mmoire texte
								;Text RAM Area (0A00H - 0BFF: 512 bytes)
								;Text RAM Area (8A00H - 8BFF: 512 bytes)
								
T_AREA		EQU	0x002B		; 40 colonnes texte si fontes de 6*8

;--------------------------------
T_OFFSET	EQU	T_HOME


;*****************************************************************************
;                                  DEFINE                                    *
;*****************************************************************************
#DEFINE		AF_FS1	PORTB , 3		; 0=fonte 8*8 , 1=fonte 6*8
#DEFINE		AF_CD	PORTB ,4		; 1=commande, 0=data
#DEFINE		AF_CE	PORTB , 5		; 0=module slectionn
#DEFINE		AF_RD	PORTB , 6		; 0=lecture
#DEFINE		AF_WR	PORTB , 7		; 0= criture
		; -------------------------------
#DEFINE		AF_DAT	PORTC		; data (8 bits)

		; -------------------------------
#DEFINE		AF_RST	PORTA , 5	; 0=reset module

;#DEFINE		AF_MD2	PORTB , 6	; 0=40 colonnes, 1=32 colonnes

;#DEFINE		AF_ECL	PORTA , 5	; 1=clairage fort

;#DEFINE		AF_STA0	PORTD , 0	; Status STA0
;#DEFINE		AF_STA1	PORTD , 1	; Status STA1
;#DEFINE		AF_STA2	PORTD , 2	; Status STA2
;#DEFINE		AF_STA3	PORTD , 3	; Status STA3

			; Commandes afficheur (nbre data)
			; -------------------------------

C_SCP		EQU	0x21		; Set Cursor Pointer (xx,yy)
					; Positionne curseur

C_SOR		EQU	0x22		; Set Offset Reg (5bits)
					; dfinit page RAM graphique

C_SAP		EQU	0x24		; Set Adress Pointer (low,high)
					; dtermine adresse de travail

C_STHA		EQU	0x40		; Set Text Home Adress (low,high)
					; Adresse dpart zone texte

C_STA		EQU	0x41		; Set Text Area (colonnes,00)
					; Nombre de colonnes texte

C_SGHA		EQU	0x42		; Set Graphic Home Adress (Low,High)
					; Adresse dpart zone graphique

C_SGA		EQU	0x43		; Set Graphic Area (Colonnes,00)
					; nombre de colonnes graphique

					; MODE SET (faire des "OR")
C_MSOR		EQU	0x80		; Mode Set OR
C_MSXOR	EQU	0x81		; Mode Set Xor
C_MSAND	EQU	0x83		; Mode Set AND
C_MSTA		EQU	0x84		; Mode Set TEXT ATTRIBUTE
C_MSEXT		EQU	0x88		; Mode Set gnrateur cars externe
C_MSINT		EQU	0x80		; Mode Set gnrateur cars interne

					; DISPLAY MODE (faire des "OR")
C_DMS		EQU	0x90		; Display Mode Set OFF
C_CURB		EQU	0x91		; clignotement curseur
C_CURD		EQU	0x92		; affichage curseur
C_TEXT		EQU	0x94		; affichage texte ON Graphique OFF
C_GRAP		EQU	0x98		; affichage Graphique ON Texte OFF
C_TEXT_GRAP		EQU	0x9C		; affichage Graphique ON Texte ON

C_CUP1		EQU	0xA0		; Cursor Pattern
					; type de curseur 1 ligne
C_CUP2		EQU	0xA1		; curseur 2 lignes
C_CUP3		EQU	0xA2		; curseur 3 lignes
C_CUP4		EQU	0xA3		; curseur 4 lignes
C_CUP5		EQU	0xA4		; curseur 5 lignes
C_CUP6		EQU	0xA5		; curseur 6 lignes
C_CUP7		EQU	0xA6		; curseur 7 lignes
C_CUP8		EQU	0xA7		; curseur 8 lignes

C_SAW		EQU	0xB0		; Set Auto Write
					; mettre en auto-write

C_SAR		EQU	0xB1		; Set Auto Read
					; mettre auto-read

C_EAM		EQU	0xB2		; End of Auto Mode
					; Fin du mode auto

C_DWI		EQU	0xC0		; Data Write & Increment (data)
					; crire data et incrmenter

C_DRI		EQU	0xC1		; Data Read & Increment (data)
					; lire data et incrmenter

C_DWD		EQU	0xC2		; Data Write & Decrement (data)
					; crire data et dcrmenter

C_DRD		EQU	0xC3		; Data Read & Decrement (data)
					; lire data et dcrmenter

C_DWN		EQU	0xC4		; Data Write & Nochange (data)
					; crire data sans incrmenter

C_DRN		EQU	0xC5		; Data Read & Nochange (data)
					; lire data sans incrmenter

C_SCRP		EQU	0xE0		; Screen Peek
					; lecture d'un octet affich

C_SCPY		EQU	0xE8		; Screen CoPY
					; copie une ligne vers cran

C_BRST		EQU	0xF0		; Bit ReSeT
					; reset bit : numro dans 3 lsb

C_BSET		EQU	0xF8		; Bit SET
					; set bit : numro dans 3 lsb

;*****************************************************************************
;                        VARIABLES BANQUE 0                                  *
;*****************************************************************************
; Zone de 80 bytes
; ----------------

	CBLOCK	0x20		; Dbut de la zone (0x20  0x6F)
	
compteur : 1		; compteur de passages dans tmr2
LCD_TEMP 		; LCD subroutines internal use
DELAY 			 ; Used in DELAYxxx routines
X_DELAY 		 	; Used in X_DELAYxxx routines
				 
			;Variables utilises par l'Include "i2c_s" (I2c Slave)
s_i_byte 			 ; tampon octet lu sur le bus I2c
s_o_byte			 ; tampon octet a envoyer sur le bus I2c


;--------------
			;Variables utilises par l'Include "i2c_m" (I2C Master)
m_i_byte 			  ; tampon octet
m_o_byte 		  ; tampon octet
m_n_bit 			 ; index (compteur de bits)


;thermometre variables
thermometre_entier			 
thermometre_deci1			 
thermometre_deci2			 
thermometre_MSB			 

;barometre variables
barometre_mille			 
barometre_centaine			 
barometre_dizaine			 
barometre_unite			 

CTRL_ESCLAVE 

DATA_LCD_I2C	 
ADR_LCD_I2C		 
cmpt_bit_i2c		 

LCD_ADR			 	; adresse du module  dfinir 

TEMP_EEADR 	 
ADR_ESCLAVE	 

heure			 
minute			 
seconde			 
TEMP_reception		 

 
SUBADRESS			 
CONTROLBYTE		 

DATA0_SAA1064		 	;variables pour transfert vers esclave
DATA1_SAA1064		 		
DATA2_SAA1064		 		
DATA3_SAA1064		 		
DATA4_SAA1064		 	
	
TEMP_MSB		 
 
TEMP1			 	
TEMP2			 
TEMP3			 
EEADR2			 
EEADRH2		 
 
select_adc		 
select_page		 
fin_datas			 

;Variables utiles pour afficheur

af_lsb		 	; data poids faible pour afficheur
af_msb		 	; data poids fort pour afficheur
af_cmd		 	; commande pour afficheur

cmpt1 		 	; compteur de boucles 1
cmpt2		 	; compteur de boucles 2
cmpt3		 	; compteur de boucles 3

	      ENDC			; Fin de la zone                		
	      	
;en BANK 1 ADRESSE A0
;********************

temp						EQU 0x0A0
temp_page					EQU 0x0A1
temp_colonne_LOW		EQU 0x0A2
temp_colonne_HIGH		EQU 0x0A3	
	
	
	
          


cbank0          MACRO
                bcf     PCLATH,3
                bcf     PCLATH,4
		ENDM

cbank1          MACRO
                bsf     PCLATH,3
                bcf     PCLATH,4
		ENDM

cbank2          MACRO
                bcf     PCLATH,3
                bsf     PCLATH,4
		ENDM

cbank3          MACRO
                bsf     PCLATH,3
                bsf     PCLATH,4
		ENDM
cbankx		MACRO  nbank
	IF (nbank&1)!=0
		bsf     PCLATH,3
	ELSE
		bcf     PCLATH,3
	ENDIF
	IF (nbank&2)!=0
		bsf	PCLATH,4
	ELSE
		bcf	PCLATH,4
	ENDIF
	ENDM
;Macros para hacer llamadas y saltos entre bancos

xcall	MACRO adest
	cbankx #v(adest>>.11)
	errorlevel -306
	call   adest
	errorlevel +306
	cbankx #v($>>.11)
	ENDM

xgoto	MACRO  adest
	cbankx #v(adest>>.11)
	errorlevel -306
	goto   adest
	errorlevel +306
	ENDM

cbankset   	MACRO	nbank
	errorlevel -306
	cbankx	nbank
	ENDM

cbankreset 	MACRO
	cbankx	$>>.11
	errorlevel +306
	ENDM
	
			; AFFICHEUR
			; ---------

SAF0	macro	commande		; envoyer commande uniquement
		movlw	commande		; prendre commande
		movwf	af_cmd			; mettre dans variable
		call		af_sendcmd		; envoyer commande
		endm

SAF1	macro	data8 , cmd		; envoyer commande et 1 data
		movlw	cmd				; prendre commande
		movwf	af_cmd			; mettre dans variable
		movlw	data8			; prendre data
		movwf	af_msb			; mettre dans variable
		call		af_send1			; envoyer msb puis cmd
		endm

SAF2	macro	data16, cmd		; envoyer commande et 2 datas
		movlw	cmd				; prendre commande
		movwf	af_cmd			; mettre dans variable
		movlw	LOW (data16)		; prendre poids faible data
		movwf	af_lsb			; mettre dans variable
		movlw	HIGH (data16)		; prendre poids fort variable
		movwf	af_msb			; mettre dans variable
		call		af_send2			; envoyer lsb puis msb puis cmd
		endm

SAF3	macro	data8 , cmd		; envoyer commande et 1 data
		movlw	cmd				; prendre commande
		movwf	af_cmd			; mettre dans variable
		movfw	data8			; prendre data
		movwf	af_msb			; mettre dans variable
		call		af_send1			; envoyer msb puis cmd
		endm
	
;DELAY	macro	nbre			; temps donn en nombre de 50ms
;	movlw	nbre			; charger argument
;	call	tempo			; appeler tempo
;	endm	
	

			;*****************************************************************************
			;                      DEMARRAGE SUR RESET                                   *
			;*****************************************************************************
			org 	0x000 		; Adresse de dpart aprs reset
		  	goto    init			; Initialiser

; ////////////////////////////////////////////////////////////////////////////
;                        I N T E R R U P T I O N S
; ///////////////////////////////////////////////////////////////////////////

			org 	0x004			; adresse d'interruption

interrup
						;sauvegarder registres
						;---------------------
					
			movwf   	w_temp  				; sauver registre W
			swapf	STATUS,w			; swap status avec rsultat dans w
			movwf	status_temp			; sauver status swapp
			movf		FSR , w				; charger FSR
			movwf	FSR_temp			; sauvegarder FSR
			movf		PCLATH , w			; charger PCLATH
			movwf	PCLATH_temp			; le sauver
			clrf		PCLATH				; on est en page 0
							
int_RB0
			bcf		STATUS , RP0			;  slectionner banque0
			bcf		STATUS , RP1
		
			btfsc 	INTCON,INTE 			; bit4 tester si interrupt RB0 autorise 
			btfss 	INTCON,INTF 			;  tester si interrupt RB0 en cours
										; signale une transition sur la pin RB0 dans le sens dtermin par
										;	INTEDG du registre OPTION (b6)		
			goto 		int_end				; non sauter 
					
			call 		INT_RB0				;  traiter interrupt RB0
			bcf 		INTCON,INTF 			; effacer flag interupt RB0 
			
int_end
			bcf		STATUS , RP0			; slectionner banque0
			bcf 		INTCON,INTF 			; effacer flag interupt RB0 
								
		;  restaurer registres
		;----------------------
			movf		PCLATH_temp , w		; recharger ancien PCLATH
			movwf	PCLATH					; le restaurer
			movf		FSR_temp , w			; charger FSR sauv
			movwf	FSR						; restaurer FSR
			swapf	status_temp,w			; swap ancien status, rsultat dans w
			movwf   	STATUS					; restaurer status
			swapf   	w_temp,f				; Inversion L et H de l'ancien W
		                       							; sans modifier Z
			swapf   	w_temp,w  				; Rinversion de L et H dans W
											; W restaur sans modifier status
			retfie						; retour d'interruption

;________________________________________________
;
;Routines d'interruptions
;________________________________________________
;
INT_RB0					;interruption provoqu par le passage de 1 vers 0 par SDA
						
;detection start bit
;*********************									; test _SCL 
			bcf 		STATUS,RP0 					; bank 0
			btfsc 	COMMANDE_I2C,_SCL			; on test si _SCL  est haut
			goto 		I2c_Slave				; reconnaissance d'une condition de start
			return								 ; sinon on sort
	
					;Procdure de traitement des trames entrantes 
					;======================================= 
I2c_Slave:


			
; lecture adresse  de controle			(lecture dun octet, loctet lu est dans s_i_byte)

			bcf 		STATUS,RP0 					; bank 0
			call 		I2c_Slave_In_Byte 				; lecture de l'adresse
													;Loctet lu estil gal  ladresse du module ?
			movfw	s_i_byte
			movwf	ADR_ESCLAVE
											
			;test si adresse reue =  DA
			;-------------------------------- 							
			movfw 	ADR_ESCLAVE				; on charge s_i_byte dans W
			xorlw	0xDA							;adresse dfinie pour le LCD
			btfss 	STATUS,Z 						; test
			return						 		 ; la transmition actuelle ne nous concerne pas
		
			bsf		FLAG_ADRESSE_ok,0						
			
;lecture adresse de controle 
;**********************************
			call 		I2c_Slave_In_Byte 				; lecture de l'adresse
													;Loctet lu estil gal  ladresse du module ?
			movfw	s_i_byte
			movwf	CTRL_ESCLAVE

			movfw 	CTRL_ESCLAVE			; on charge RCREG dans W
			xorlw	0xDB					;adresse dfinie pour l'HORLOGE DB
			btfsc		STATUS,Z	
				goto		RECEPTION_HORLOGE
				
			xorlw	(0xDC ^ 0xDB)			;adresse dfinie pour la TEMPERATURE DC
			btfsc		STATUS,Z
				goto		RECEPTION_TEMPERATURE
				
			xorlw	(0xDD ^ 0xDC)			;adresse dfinie pour le BAROMETRE DD
			btfsc		STATUS,Z
				goto		RECEPTION_BAROMETRE

			return

RECEPTION_HORLOGE

; lecture DATAS heure
;	
			call 		I2c_Slave_In_Byte 			; lecture du numro de fonction demande
			movfw	s_i_byte
			movwf	heure				;	DATA_LCD_I2C			
		
; lecture DATAS minute
; 			
			call 		I2c_Slave_In_Byte 			; lecture du numro de fonction demande
			movfw	s_i_byte
			movwf	minute				;	DATA_LCD_I2C				
						
; lecture DATAS seconde
;			
			call 		I2c_Slave_In_Byte 			; lecture du numro de fonction demande
			movfw	s_i_byte
			movwf	seconde				;	DATA_LCD_I2C	
			
			return	

RECEPTION_TEMPERATURE

; lecture DATAS thermometre_MSB
;			
			call 		I2c_Slave_In_Byte 			; lecture du numro de fonction demande
			movfw	s_i_byte
			movwf	 thermometre_MSB			;	DATA_LCD_I2C	

; lecture DATAS thermometre_entier
;			
			call 		I2c_Slave_In_Byte 			; lecture du numro de fonction demande
			movfw	s_i_byte
			movwf	 thermometre_entier			;	DATA_LCD_I2C

; lecture DATAS thermometre_deci1	
;			
			call 		I2c_Slave_In_Byte 			; lecture du numro de fonction demande
			movfw	s_i_byte
			movwf	thermometre_deci1				;	DATA_LCD_I2C

; lecture DATAS thermometre_deci2
;			
			call 		I2c_Slave_In_Byte 			; lecture du numro de fonction demande
			movfw	s_i_byte
			movwf	 thermometre_deci2			;	DATA_LCD_I2C

			return

RECEPTION_BAROMETRE

; lecture DATAS barometre_mille
;	
			call 		I2c_Slave_In_Byte 			; lecture du numro de fonction demande
			movfw	s_i_byte
			movwf	barometre_mille		;	DATA_LCD_I2C

; lecture DATAS barometre_centaine	
;			
			call 		I2c_Slave_In_Byte 			; lecture du numro de fonction demande
			movfw	s_i_byte
			movwf	barometre_centaine			;	DATA_LCD_I2C
			
; lecture DATAS barometre_dizaine
;			
			call 		I2c_Slave_In_Byte 			; lecture du numro de fonction demande
			movfw	s_i_byte
			movwf	 barometre_dizaine		;	DATA_LCD_I2C
			
; lecture DATAS barometre_unite
;			
			call 		I2c_Slave_In_Byte 			; lecture du numro de fonction demande
			movfw	s_i_byte
			movwf	barometre_unite			;	DATA_LCD_I2C
						
			return						
						;************************************************
						; 			ROUTINES GESTION BUS I2C                   
						;************************************************
I2c_Slave_In_Byte
;--------------
		bcf 		STATUS,RP0  					; bank 0
		clrf 	s_i_byte         			; on vide le tampon d'entre s_i_byte
	
		movlw 	0x08       				; on initialise l'index  8 bits
		movwf 	cmpt_bit_i2c			; on charge dans "cmpt_bit_i2c"

;--------------	
I2c_Slave_In_Bit  
;--------------
		btfsc		PORTB,1    				; on attend que _SCL  soit BAS   ==> RB1
		goto 		$-1						; on boucle

		btfss		PORTB,1       				; on attend que _SCL  soit HAUT
		goto 		$-1  						 ; on boucle
		
 		call		DELAY_10us 				;se positionne sur milieu de la data  lire	 
  	    	
		btfss 	PORTB,0  					; on lit la donne prsente sur _SDA  en testant son tat
		goto		I2c_Slave_In_Bit_0	
		goto		I2c_Slave_In_Bit_1

I2c_Slave_In_Bit_0
	;--------------
		bcf 		STATUS,C      			; on force  un 0
		rlf 		s_i_byte,f       					; on dcale  gauche s_i_byte (le bit est  0) 
					     						; _SDA  est  0, on met le bit de poid faible  0
		goto		I2c_Slave_In_Bit_Next

I2c_Slave_In_Bit_1
	;--------------
		bsf 		STATUS,C        			; on force  un 1
		rlf 		s_i_byte,f       					; on dcale  gauche s_i_byte (le bit est  1) 
					     						; _SDA  est  1, on met le bit de poid faible  1

I2c_Slave_In_Bit_Next
	;--------------
		decfsz 	cmpt_bit_i2c,f          				; on dcremente l'index
		goto      	I2c_Slave_In_Bit    				    ; on lit le bit suivant tant que l'index n'est pas 0

		return



;

						; Envoi d'un ACK sur le Bus par le LCD (sur le neuvime coup d'horloge)

;I2c_Slave_Ack
;;	; 
;		bcf 		COMMANDE_I2C,_SDA        		; on met _SDA   zro	
;			; Le matre a laiss _SDA   l'tat HAUT, on va donc le forcer  l'tat BAS.
;				call		DELAY_07us 	
;  		goto		LIGNE_SCL
; 	
;;============================
;; N'envoie PAS de ACK sur le Bus (sur le neuvime coup d'horloge)
;
;I2c_Slave_No_Ack
;;*****		
;		bsf 		COMMANDE_I2C,_SDA        		;	; on laisse _SDA  au niveau HAUT 	
;				; Le matre a laiss _SDA   l'tat HAUT, on va donc le confirmer
;LIGNE_SCL
;		;--------------			 
;		movlw	B'11111110'     	; 
;		tris		PORTB           	;SDA en sortie sur PORTB,0
;							;SCL en entree sur PORTB,1
;		;--------------						
;		btfsc 	COMMANDE_I2C,_SCL 			; on attend que _SCL  soit BAS
;		goto 		$-1							; on boucle          	
;			
;		btfss 	COMMANDE_I2C,_SCL        		; on attend que _SCL  soit HAUT (neuvime coup d'horloge)
;		goto 		$-1							; on boucle
;	
;		btfsc 	COMMANDE_I2C,_SCL 			; on attend que _SCL  soit BAS	
;		goto 		$-1 							; on boucle
;		
;		
;		;--------------		
;		movlw	B'11111111'     	;  
;		tris		PORTB           	;SDA en entree
;		;--------------	
;
;		return        
;;============================
;I2c_Slave_Fin_No_Ack
;			
;		call		I2c_Slave_No_Ack
;			
;		return    					; on termine en retournant au gestionnaire d'interruptions
;
;	
;
;;============================
;I2c_Slave_Fin
;		clrf		ADR_ESCLAVE	
;I2c_Slave_Fin1				
;		clrf		heure		
;		clrf		minute
;		clrf		seconde
;		
;		movlw	B'11111111'     	;  
;		tris		PORTB           	;SDA en entre
;		return  					  ; on termine en retournant au gestionnaire d'interruptions
;				
;						;============================
;						; Envoi d'un octect sur le Bus.
;
;I2c_Slave_Out_Byte
;;
;		movwf	s_o_byte					; on charge W dans s_o_byte
;	
;		movlw 	8	        					; on initialise l'index  8 bits
;		movwf 	cmpt_bit_i2c				; on charge dans s_n_bit
;		
;;--------------
;I2c_Slave_Out_Bit  
;
;
;		btfsc 	COMMANDE_I2C,_SCL  			; on attend que _SCL  soit BAS
;		goto 		$-1			; on boucle
;	
;		nop
;		nop
;	
;		; On configure _SDA  en entre
;	
;		movlw	B'11111111'     	;  
;		tris		PORTB           	;SDA  
;
;I2c_Slave_Out_Bit_Wait
;
;	   	; On lit le bit suivant de s_o_byte et on le teste
;	
;		bcf 		STATUS,C   
;		rlf 		s_o_byte,f	       	; on dcale o_byte  gauche via la retenue
;	
;		btfsc 	STATUS,C        	; on teste la retenue
;		goto		I2c_Slave_Out_Bit_Next	; c'est un 1 donc on ne touche pas  la ligne
;
;		; C'est un zro, on configure _SDA  en sortie
;	
;		bcf 		COMMANDE_I2C,_SDA        		; et on force _SDA   zro
;	
;		movlw	B'11111110'     	;  
;		tris		PORTB           	;SDA en sortie
;
;I2c_Slave_Out_Bit_Next
;
;		btfss 	COMMANDE_I2C,_SCL        		; on attend que _SCL  soit HAUT
;		goto 		I2c_Slave_Out_Bit_Next  ; on boucle
;	
;		decfsz 	cmpt_bit_i2c,f            	; on dcremente l'index
;		goto 		I2c_Slave_Out_Bit     	; on envoie le bit suivant tant que l'index n'est pas  0
;
;		btfsc 	COMMANDE_I2C,_SCL  			; on attend que _SCL  soit BAS
;		goto 		$-1	; on boucle
;	
;		nop
;		nop
;	
;		; On configure _SDA  en entre
;	
;		movlw	B'11111111'     	;  
;		tris		PORTB           	;SDA 
;	
;		return
;
		
		
			;************* a 2uS delay @ 15MHz360 X-tal
DELAY_02us 	
		movlw 	D'2' 		; +1     1 cycle
		movwf 	DELAY 		; +2     1 cycle
		goto 	DELAY_LOOP1 	;        2 cycles
		
			;************* a 5uS delay @ 15MHz360 X-tal
DELAY_05us 	
		movlw 	D'5' 		; +1     1 cycle
		movwf 	DELAY 		; +2     1 cycle
		goto 	DELAY_LOOP1 	;        2 cycles
			;************* a 7uS delay @ 15MHz360 X-tal
DELAY_07us 	
		movlw 	D'6' 		; +1     1 cycle
		movwf 	DELAY 		; +2     1 cycle
		goto 	DELAY_LOOP1 	;        2 cycles
		
			;************* a 10uS delay @ 15MHz360 X-ta		
DELAY_10us 	
		movlw 	D'11' 		; +1     1 cycle
		movwf 	DELAY 		; +2     1 cycle
		goto 	DELAY_LOOP1 

			;************* a 15uS delay @ 15MHz360 X-tal
DELAY_15us 	
		movlw 	D'19' 		; +1     1 cycle
		movwf 	DELAY 		; +2     1 cycle
		goto 	DELAY_LOOP1 
		
DELAY_20us 	
		movlw 	D'25' 		; +1     1 cycle
		movwf 	DELAY 		; +2     1 cycle
		goto 	DELAY_LOOP1 		
		
DELAY_25us 	
		movlw 	D'31' 		; +1     1 cycle
		movwf 	DELAY 		; +2     1 cycle
		goto 	DELAY_LOOP1 
		
DELAY_30us 	
		movlw 	D'38' 		; +1     1 cycle
		movwf 	DELAY 		; +2     1 cycle
		goto 	DELAY_LOOP1 						

DELAY_45us 	
		movlw 	D'55' 		; +1     1 cycle
		movwf 	DELAY 		; +2     1 cycle
		goto 	DELAY_LOOP1 			

DELAY_100us 	
		MOVLW 	D'130' 		
		MOVWF 	DELAY 		
		goto 	DELAY_LOOP1

		
DELAY_LOOP1 
		decfsz 	DELAY, F  		; +1     1 cycle	 
		goto 	DELAY_LOOP1  		; +1     2 cycles
		bcf		STATUS,RP0 	;sort avec bank0
		return 	
		
DELAY_500ms			; 512m seconde exactement
;***********
		clrf	TEMP1
		clrf	TEMP2

		movlw	0xA ;     0x15= 1.076  seconde exactement
		movwf	TEMP3
	
loop_500ms	
		decfsz	TEMP1,f
		goto	loop_500ms	
		decfsz	TEMP2,f
		goto	loop_500ms		
		decfsz	TEMP3,f
		goto	loop_500ms	
		return	
		
DELAY_150ms			; 153.755 exactement
;***********
		clrf	TEMP1
		clrf	TEMP2
		movlw	0x03
		movwf	TEMP3
	
loop_150ms
		decfsz	TEMP1,f
		goto	loop_150ms
		decfsz	TEMP2,f
		goto	loop_150ms	
		decfsz	TEMP3,f
		goto	loop_150ms
		return
		
DELAY_100ms
;***********
		clrf	TEMP1
		clrf	TEMP2
		movlw	0x02
		movwf	TEMP3
loop_100ms
		decfsz	TEMP1,f
		goto	loop_100ms
		decfsz	TEMP2,f
		goto	loop_100ms		;102ms 
		decfsz	TEMP3,f
		goto	loop_100ms			
		return

								; ////////////////////////////////////////////////////////////////////////////
								
								;                    P R O G R A M M E
								
								; ////////////////////////////////////////////////////////////////////////////

	;*****************************************************
	;                          INITIALISATIONS                                   *
	;*****************************************************
init		
;		; Registre d'options (banque 1)
					; -----------------------------
			bsf		STATUS,RP0		; passer en banque 1
			
					; Initialiser portB
					; -----------------
												
			movlw	OPTIONVAL			; charger masque
			movwf	OPTION_REG		; initialiser registre option
		
			movlw	0x06				; valeur pour ADCON1
			movwf	ADCON1			; tous les RA en digital PCFG=0110 
		
			movlw	B'11011111'			; pour TRISA
			movwf	TRISA			;RA5 sortie reset afficheur
										 	
		
			movlw	B'00000011'			; pour TRISB
			movwf	TRISB				; rb1 rb2 en entre
			
									;  RB0  |    21  |  S |  SDA	   | SIMULATION  I2C  SDA         DATAS IN du maitre	 
									;  RB1  |    22  |  S |  SCL      | SIMULATION  I2C  SCL          CLOCK IN du maitre
									
									;  RB2  |    23  |  S  |    RV   | REVERSE	 	 	  
									;  RB3  |    24  |  S  | FS       | FONT SELECT


									;  RB4  |    25  | S |  C/D  	| COMMANDE  /   DATA		 	
									;  RB5  |    26  | S |  CE      	|CHIP ENABLE
									;  RB6  |    27  | S |  RD	| DATA READ
									;  RB7  |    28  | S |  WR	| DATA WRITE	

			movlw	B'00000000'			; pour TRISC  
			movwf	TRISC				; RC0...7     en sortie  
									;  RC0  |    11  |  S  	| D0 				|  	BUS DE DATAs  LCD
									;  RC1  |    12  |  S  	| D1 				|  
									;  RC2  |    13  | S 	| D2 	      		 	|	 
									;  RC3  |    14  | S	| D3      			|  
									;  RC4  |    15  | S  	| D4 				|  
									;  RC5  |    16  |  S  	| D5				|  
									;  RC6  |    17  |  S  	| D6 				| 
									;  RC7  |    18  |  S 	| D7 				| 												
								

			; registres interruptions (banque 1)
			; ----------------------------------
	
			movlw		INTCONVAL		; charger valeur registre interruption
			movwf		INTCON			; initialiser interruptions	(60= PEIE b6 :interruption priph valid)
										;    T0IE b5 :Tmr0 Interrupt Enable bit 
										; GIE  b7 : masque autorisation gnrale interrupt 
										; PEIE b6 : masque autorisation gnrale priphriques 
										; T0IE b5 :Tmr0 Interrupt Enable bit :
										            ;Valide linterruption gnre par le dbordement du timer0.
										; INTE b4 : masque interruption RB0/Int
						 
										; RBIE b3 : masque interruption RB4/RB7 
										; T0IF b2 : flag tmr0 
										; INTF b1 : flag RB0/Int 
										; RBIF b0 : flag interruption RB4/RB7
		
		
			movlw		PIE1VAL		; Initialiser registre 
			movwf		PIE1			; interruptions priphriques 1 
										;(b1 : masque interrupt TMR2IE  en service
										;-bit1 TMR2IE Correspondance de valeurs pour le timer TMR2
										;-bit0 TMR1IE Dbordement du timer TMR1


;				; initialiser Timer 2
;				; -------------------
;			movlw	PRVAL				; valeur de "dbordement" de tmr2 ==>(249) ou (F9)
;			movwf	PR2					; dans PR2
;;	
				; initialiser Timer 0
				; -------------------
			bcf		STATUS,RP0		; repasser banque 0
		
			clrf 		TMR0 				; commencer le comptage  partir de 0
			clrf		cmpt_TIMER_0				;reset



;			; initialiser Timer 2
;			; -------------------
;			movlw 		B'01111111'		; postdiviseur  16,prdiviseur  16,timer ON
;			movwf		T2CON			; dans registre de contrle
;	
;										;T2CON (en banque 0)
;										;- b7 : non utilis, laisser  0
;										;- b6 : TOUTPS3 : Timer2 OUTput PostScale bit 3
;										;- b5 : TOUTPS2 : Timer2 OUTput PostScale bit 2
;										;- b4 : TOUTPS1 : Timer2 OUTput PostScale bit 1
;										;- b3 : TOUTPS0 : Timer2 OUTput PostScale bit 0
;										;- b2 : TMR2ON : TiMeR 2 ON
;										;- b1 : T2CKPS1 : Timer 2 ClocK PreScale bit 1
;										;- b0 : T2CKPS0 : Timer 2 ClocK PreScale bit 0
	
;				; initialiser variable
;				; --------------------
;			movlw		COMPTVAL		; valeur de recharge d'60'
;			movwf		compteur		; dans compteur de passage interruption
;
				

	
				; autoriser interruptions (banque 0)
				; ----------------------------------
			bsf		INTCON,GIE			; valider interruptions gnrale
	
										;bit 7 GIE: Global Interrupt Enable bit
											;1 = Enables all unmasked interrupts
											;0 = Disables all interrupts
											

		
			; Effacer RAM banque 0
			; ---------------------
			bcf		STATUS,RP0	; slectionner banque 0
			movlw	0x20		; initialisation pointeur
			movwf	FSR		; d'adressage indirect
init1
			clrf		INDF		; effacer ram
			incf		FSR,f		; pointer sur suivant
			btfss	FSR,7		; tester si fin zone atteinte (>7F)
			goto	init1		; non, boucler

				
			;  INIT  AFFICHEUR  ;
			; ---------------------				
			call		DELAY_500ms			;wait
			call		DELAY_500ms		
			call		LCDINIT				;initialisation de l'afficheur
				 
			;EFFACE  LCD  RAM 	;
			; ---------------------
			call		LCD_af_clrtxt
			
			;  INIT  suite  ;
			; -----------------				
			nop
			SAF0	C_MSOR		; envoyer mode OR
			nop
			SAF0	C_TEXT 		; placer en mode texte  


;STATUS_SAA1064
;;****************************
;
;		call		Read_SAA1064	;le simple fait de lire le registre remets le bit Pr 0   0	
				
				;*****************************************************************************
				;                      PROGRAMME PRINCIPAL                                   *
				;*****************************************************************************
start	
			bcf     	STATUS,RP1
			bcf     	STATUS,RP0     	;Select Bank 0
			

;					
; 					;		
;					;	SAA1064 AFFICHAGE
;					;	
;init_registre	
;			movlw	0x00
;			movwf	SUBADRESS	;SC SB SA = 0
;			
;control_registre				
;			movlw	0x17
;			movwf	CONTROLBYTE		;1er octet = registre 0 = contrle
;								
;;diz_heu_h			
;			swapf	heure,w
;			call		BCD_7seg
;			movwf	DATA1_SAA1064
;						
;						
;;heu_h		
;			movfw	heure
;			call		BCD_7seg	
;			movwf	DATA2_SAA1064
;			bsf		DATA2_SAA1064,7				
;										
;;diz_mn_h			
;			swapf	minute,w
;			call		BCD_7seg
;			movwf	DATA3_SAA1064
;					
;									
;;mn_h		
;			movfw	minute
;			call		BCD_7seg
;			movwf	DATA4_SAA1064
;			
;			call		Write_SAA1064
;									
;	

			
;AUTORISE INTERRUPTION RB0
;--------------------------------------------
set_INTE
	         	bsf		INTCON,INTE			; b4 : masque interruption RB0/Int 	
	         	
;AFFICHAGE	HORLOGE
;-----------------------------------------	

;heure	
			nop
			SAF2	0x0080+d'20',C_SAP			;	envoie commande Set Adresse Pointer (cd_24) , adr init  42
			nop			
			movfw	heure
			swapf	heure,w
			andlw	0x0F
			iorlw		0x10
			movwf	TEMP
			SAF3	TEMP,C_DWI		;copie de SAF1 en adressage direct
			
			movfw	heure
			andlw	0x0F
			iorlw		0x10
			movwf	TEMP
			SAF3	TEMP,C_DWI		;copie de SAF1 en adressage direct
			
;separateur :
			nop
			SAF1	0x1A ,C_DWI			;	envoie commande  Data Write & Increment (data)
			nop							; 	crire data (B) et incrmenter			
			
			
;minute
			nop
			;	SAF2		0x0010,C_SAP			;	envoie commande Set Adresse Pointer (cd_24) , adr init  10
			nop			
			movfw	minute
			swapf	minute,w
			andlw	0x0F
			iorlw		0x10
			movwf	TEMP
			SAF3	TEMP,C_DWI		;copie de SAF1 en adressage direct
			
			movfw	minute
			andlw	0x0F
			iorlw		0x10
			movwf	TEMP
			SAF3	TEMP,C_DWI		;copie de SAF1 en adressage direct
			
;separateur
			nop
			SAF1	0x1A,C_DWI			;	envoie commande  Data Write & Increment (data)
			nop							; 	crire data (B) et incrmenter			
			
;seconde			
			nop
			;	SAF2		0x0010,C_SAP			;	envoie commande Set Adresse Pointer (cd_24) , adr init  10
			nop			
			movfw	seconde
			swapf	seconde,w
			andlw	0x0F
			iorlw		0x10
			movwf	TEMP
			SAF3	TEMP,C_DWI		;copie de SAF1 en adressage direct
			
			movfw	seconde
			andlw	0x0F
			iorlw		0x10
			movwf	TEMP
			SAF3	TEMP,C_DWI		;copie de SAF1 en adressage direct
				
			                                                	;	         	
						;        TEMPERATURE
						;	 
			nop
			SAF2	0x0042+d'10',C_SAP			;	envoie commande Set Adresse Pointer (cd_24) , adr init   
			nop					
				
				
		swapf	thermometre_entier,w
			andlw	0x0F
			iorlw		0x10
			movwf	TEMP
			SAF3	TEMP,C_DWI		;copie de SAF1 en adressage direct
					
		movfw	thermometre_entier
			andlw	0x0F
			iorlw		0x10
			movwf	TEMP
			SAF3	TEMP,C_DWI		;copie de SAF1 en adressage direct
					
;separateur C
			nop
			SAF1	0x07 ,C_DWI			;	envoie commande  Data Write & Increment (data)
			nop							; 	crire data (B) et incrmenter			
;			nop
;			SAF1	0x43 ,C_DWI			;	envoie commande  Data Write & Increment (data)
;			nop							; 	crire data (B) et incrmenter					 
		
		movfw	thermometre_deci1
			andlw	0x0F
			iorlw		0x10
			movwf	TEMP
			SAF3	TEMP,C_DWI		;copie de SAF1 en adressage direct
			
		movfw	thermometre_deci2
			andlw	0x0F
			iorlw		0x10			
			movwf	TEMP
			SAF3	TEMP,C_DWI		;copie de SAF1 en adressage direct
							
				
				
				
				
	         							;	         	
								;        BAROMETRIE
								;	    
								     	
BAROMETRE
			nop
			SAF2	0x0280+d'10',C_SAP			;	envoie commande Set Adresse Pointer (cd_24) , adr init  42
			nop	
			
		movfw	barometre_mille
			andlw	0x0F
			iorlw		0x10
			movwf	TEMP
			SAF3	TEMP,C_DWI		;copie de SAF1 en adressage direct
					 
 		movfw	barometre_centaine	
			andlw	0x0F
			iorlw		0x10
			movwf	TEMP
			SAF3	TEMP,C_DWI		;copie de SAF1 en adressage direct
						
		movfw	barometre_dizaine
			andlw	0x0F
			iorlw		0x10
			movwf	TEMP
			SAF3	TEMP,C_DWI		;copie de SAF1 en adressage direct
					 
 		movfw	barometre_unite
			andlw	0x0F
			iorlw		0x10
			movwf	TEMP
			SAF3	TEMP,C_DWI		;copie de SAF1 en adressage direct
		
			nop
			SAF1	0x00 ,C_DWI			;	envoie commande  Data Write & Increment (data)
			nop							; 	crire data (B) et incrmenter					
			nop
			SAF1	0x48 ,C_DWI			;	envoie commande  Data Write & Increment (data)
			nop							; 	crire data (B) et incrmenter	
			nop
			SAF1	0x30 ,C_DWI			;	envoie commande  Data Write & Increment (data)
			nop							; 	crire data (B) et incrmenter	
			nop
			SAF1	0x21 ,C_DWI			;	envoie commande  Data Write & Increment (data)
			nop							; 	crire data (B) et incrmenter				

			
			
		goto		start
		
		
		

;*****************************************************************************
;	SOUS-PROGRAMME	de  TEST des VALEURS de VARIABLES
;******************************************************************************

BCD_7seg
	              	movwf	TEMP
			movf		PCLATH , w		; charger PCLATH
			movwf	PCLATH_temp		; le sauver
			
			movlw 	0x01
			movwf 	PCLATH
						
			movfw	TEMP
			andlw	b'00001111'
;CONVERT_PCL	
			addwf 	PCL , f    ; ajouter w  PCL
	
			
			retlw		b'00111111'	; "0"     b'Pgfedcba' suivant la figure
			retlw		b'00000110'	; "1"                  d'un 7 Segments
			retlw		b'01011011'	; "2"                     -----------
			retlw		b'01001111'	; "3"                    |     a      |
			retlw		b'01100110'	; "4"                    |              |
			retlw		b'01101101'	; "5"                    |f         b |
			retlw		b'01111101'	; "6"                    |              |
			retlw		b'00000111'	; "7"                    |     g      |
			retlw		b'01111111'	; "8"                     -----------
			retlw		b'01101111'	; "9"                    |               |
			retlw		b'01110111'	; "A"                    |              |
			retlw		b'01111100'	; "b"                    |e         c|
			retlw		b'00111001'	; "C"                    |              |
			retlw		b'01011110'	; "d"                    |     d       |
			retlw		b'01111001'	; "E"                     -----------   o P
			retlw		b'01110001'	; "F"                    Point dcimal--^
			

	
	
;*****************************************************************************
;                        Initialiser afficheur                               *
;*****************************************************************************
;-----------------------------------------------------------------------------
; Dtermine le mode de travail de l'afficheur et initialise les paramtres
;-----------------------------------------------------------------------------
LCDINIT
					; initialiser hardware
					; --------------------
			bsf		AF_WR		; pas d'criture
			bsf		AF_RD		; pas de lecture
			bsf		AF_CE		; dslectionner afficheur
			bsf		AF_CD		; mode commande
			bsf		AF_FS1		; caractres 6*8 pixels
			
	 		
		;	bcf		AF_MD2		; travail en 40 colonnes
			
			bsf		AF_RST		; fin du reset
			call		DELAY_100ms			; attendre 100ms
			bcf		AF_RST		; reset afficheur
			call		DELAY_100ms			; attendre 100ms
			bsf		AF_RST		; fin du reset
			call		DELAY_100ms			; attendre 100ms
		
					; initialisation software
					; -----------------------
			SAF2	G_HOME,C_SGHA	; envoyer adresse graphique
			SAF2	G_AREA,C_SGA	; envoyer largeur graphique
			SAF2	T_HOME,C_STHA	; envoyer adresse texte
			SAF2	T_AREA,C_STA	; envoyer largeur texte
			return			; et retour

;*****************************************************************************
;                          Effacer zone texte                                *
;*****************************************************************************
;-----------------------------------------------------------------------------
; efface la zone texte
;-----------------------------------------------------------------------------
LCD_af_clrtxt
		nop
		SAF2	T_HOME,C_SAP	; pointer mmoire texte
		
		clrf		af_msb			; caractre vide  envoyer
		movlw	C_DWI			; commande envoyer et incrmenter
		movwf	af_cmd			; dans commande
	
		movlw	D'16'				; pour 16 lignes en mode texte et 128 en graphique
		movwf	cmpt2			; dans compteur de lignes
clear2
		movlw	T_AREA			; pour nombre de colonnes
		movwf	cmpt1			; dans compteur de colonnes
clear1
		call		af_send1			; crire espace
		decfsz	cmpt1 , f			; dcrmenter colonne
		goto		clear1			; pas dernire, suivante
		decfsz	cmpt2 , f			; dcrmenter ligne
		goto		clear2			; pas dernire, nouvelle ligne
		return					; fin, retour



;*****************************************************************************
;                          Envoi data sur afficheur                          *
;*****************************************************************************
;-----------------------------------------------------------------------------
; Envoie la data lsb contenue dans af_lsb vers l'afficheur
; aucune variable modifie
;-----------------------------------------------------------------------------
af_send2
			call		af_stat01			; vrifier status01
			movf		af_lsb , w			; charger data lsb
			movwf	AF_DAT			; placer data sur le bus
			bcf		AF_CD			; prciser data
			bcf		AF_CE			; slectionner afficheur
			bcf		AF_WR			; ordre d'criture
			nop						;	IF (FREQ > 20)					; si frquence > 20MHz
			nop						;	 nop							; attendre en supplment
			nop						;	ENDIF						; fin de condition
			bsf		AF_WR			; fin d'criture
			bsf		AF_CE			; dslectionner afficheur

;-----------------------------------------------------------------------------
; Envoie la data msb contenue dans af_msb vers l'afficheur
; aucune variable modifie
;-----------------------------------------------------------------------------
af_send1
			call		af_stat01			; vrifier status01
			movf		af_msb , w			; charger data msb
			movwf	AF_DAT			; placer data sur le bus
			bcf		AF_CD			; prciser data
			bcf		AF_CE			; slectionner afficheur
			bcf		AF_WR			; ordre d'criture
			nop						;	IF (FREQ > 20)					; si frquence > 20MHz
			nop						;	 nop							; attendre en supplment
			nop						;	ENDIF						; fin de condition
			bsf		AF_WR			; fin d'criture
			bsf		AF_CE			; dslectionner afficheur

;-----------------------------------------------------------------------------
; Envoie la commande contenue dans af_cmd vers l'afficheur
; aucune variable modifie
;-----------------------------------------------------------------------------
af_sendcmd
			call		af_stat01			; vrifier status01
			movf		af_cmd , w			; charger commande
			movwf	AF_DAT			; placer data sur le bus
			bsf		AF_CD			; prciser commande
			bcf		AF_CE			; slectionner afficheur
			bcf		AF_WR			; ordre d'criture
			nop						;	IF (FREQ > 20)					; si frquence > 20MHz
			nop						;	 nop							; attendre en supplment
			nop						;	ENDIF						; fin de condition
			bsf		AF_WR			; fin d'criture
			bsf		AF_CE			; dslectionner afficheur
			return					; et retour



;*****************************************************************************
;                         Envoie une data en autowrite                       *
;*****************************************************************************
;-----------------------------------------------------------------------------
; L'afficheur doit avoir t mis en mode auto
; la data est contenue dans w
; pas de variable modifie
;-----------------------------------------------------------------------------
af_autowrite
			call		af_stat3			; vrifier status3
			movwf	AF_DAT			; placer data  envoyer
			bcf		AF_CD			; signaler data
			bcf		AF_WR			; signaler criture
			bcf		AF_CE			; slectionner afficheur
			nop						;	IF (FREQ > 20)					; si frquence > 20MHz
			nop						;	 nop							; attendre en supplment
			nop						;	ENDIF						; fin de condition
			bsf		AF_CE			; dslectionner afficheur
			bsf		AF_WR			; fin d'criture
			return					; et retour

;*****************************************************************************
;                          Envoie commande de fin d'autowrite                *
;*****************************************************************************
;-----------------------------------------------------------------------------
; Envoie la fin d'autowrite
; aucune variable modifie
;-----------------------------------------------------------------------------
af_endautow
			call		af_stat3			; vrifier status3
			movlw	C_EAM			; commande fin automode
			movwf	AF_DAT			; placer data
			bsf		AF_CD			; prciser commande
			bcf		AF_WR			; ordre d'criture
			bcf		AF_CE			; slectionner afficheur
			nop						;	IF (FREQ > 20)					; si frquence > 20MHz
			nop						;	 nop							; attendre en supplment
			nop						;	ENDIF						; fin de condition
			bcf		AF_CE			; dslectionner afficheur
			bsf		AF_WR			; fin d'criture
			return					; et retour


;*****************************************************************************
;                        Teste les status STA0 et STA1                       *
;*****************************************************************************
;-----------------------------------------------------------------------------
; Teste le status STA0 et STA1
; reste dans la routine jusqu' rponse correcte
;-----------------------------------------------------------------------------
af_stat01
			clrwdt					; effacer watchdog
			bsf		AF_RD			; annuler lecture
			bsf		AF_CE			; dslectionner afficheur
			
			bsf		STATUS , RP0		; passer banque1
			clrf		AF_DAT			; PORT en sortie
			comf		AF_DAT , f		; PORT en entre
			bcf		STATUS , RP0		; repasser banque0
			
			bsf		AF_CD			; mode commande
			bcf		AF_CE			; slectionner afficheur
			bcf		AF_RD			; mode lecture
			nop						; attendre un peu
			nop
			nop
			btfsc		AF_DAT,0			; tester si bit0 status = 1
			btfss		AF_DAT,1			; oui, tester si bit1 status = 1
			goto		af_stat01			; non, recommencer
		
			bsf		AF_RD			; annuler lecture
			bsf		AF_CE			; dslectionner afficheur
			
			bsf		STATUS , RP0		; passer banque1
			clrf		AF_DAT			; passer data en sortie
			bcf		STATUS , RP0		; repasser banque0
			
			return					; et retour

;*****************************************************************************
;                        Teste le status STA3                                *
;*****************************************************************************
;-----------------------------------------------------------------------------
; Teste le status STA3
; reste dans la routine jusqu' rponse correcte
;-----------------------------------------------------------------------------
af_stat3
			clrwdt					; effacer watchdog
			bsf		AF_RD			; annuler lecture
			bsf		AF_CE			; dslectionner afficheur
			
			bsf		STATUS , RP0		; passer banque1
			clrf		AF_DAT			; PORT en sortie
			comf		AF_DAT , f		; PORT en entre
			bcf		STATUS , RP0		; repasser banque0
			
			bsf		AF_CD			; mode commande
			bcf		AF_CE			; slectionner afficheur
			bcf		AF_RD			; mode lecture
			nop						; attendre un peu
			nop
			nop
			btfss		AF_DAT,3			; oui, tester si bit3 status = 1
			goto		af_stat3			; non, recommencer
		
			bsf		AF_RD			; annuler lecture
			bsf		AF_CE			; dslectionner afficheur
			
			bsf		STATUS , RP0		; passer banque1
			clrf		AF_DAT			; passer data en sortie
			bcf		STATUS , RP0		; repasser banque0
			
			return					; et retour


;***************************************************************************************
;		AFFICHE 	PETIT CHIFFRES  sur 1 ligne
;***************************************************************************************


TEST_0_F	
	;		movfw	DATA_LCD_I2C
		           movwf	TEMP_reception
			movf		PCLATH , w		; charger PCLATH
			movwf	PCLATH_temp		; le sauver
			
			movlw 	0x02
			movwf 	PCLATH
						
			movfw	TEMP_reception

CONVERT_PCL	
			addwf 	PCL , f    ; ajouter w  PCL
	
			goto    	ZERO	     
			goto    	UN           
			goto    	DEUX         
			goto    	TROIS        
			goto    	QUATRE       
			goto    	CINQ         
			goto    	SIX  
			goto    	SEPT
			goto    	HUIT
			goto    	NEUF          
			goto    	AAAA          
			goto    	BBBB          
			goto    	CCCC          
			goto    	DDDD          
			goto    	EEEE          
			goto    	FFFF 


;*****************************************************************************
;			AIGUILLAGE  AFFICHAGE  LCD  GRAPHIQUE
;*****************************************************************************

ZERO	movlw	zero
		goto 		TRANSFERT_LCD_GRAPHIQUE
UN		movlw	un
		goto 		TRANSFERT_LCD_GRAPHIQUE
DEUX	movlw	deux
		goto 		TRANSFERT_LCD_GRAPHIQUE
TROIS	movlw	trois
		goto 		TRANSFERT_LCD_GRAPHIQUE
QUATRE	movlw	quatre
		goto 		TRANSFERT_LCD_GRAPHIQUE
CINQ	movlw	cinq
		goto 		TRANSFERT_LCD_GRAPHIQUE
SIX		movlw	six
		goto 		TRANSFERT_LCD_GRAPHIQUE
SEPT	movlw	sept
		goto 		TRANSFERT_LCD_GRAPHIQUE
HUIT	movlw	huit
		goto 		TRANSFERT_LCD_GRAPHIQUE
NEUF	movlw	neuf
		goto 		TRANSFERT_LCD_GRAPHIQUE
AAAA	movlw	a1
		goto 		TRANSFERT_LCD_GRAPHIQUE
BBBB	movlw	a1+8
		goto 		TRANSFERT_LCD_GRAPHIQUE
CCCC	movlw	c1
		goto 		TRANSFERT_LCD_GRAPHIQUE
DDDD	movlw	d1
		goto 		TRANSFERT_LCD_GRAPHIQUE
EEEE	movlw	e1
		goto 		TRANSFERT_LCD_GRAPHIQUE
FFFF	movlw	f1
		goto 		TRANSFERT_LCD_GRAPHIQUE

;********************************************************
;		GRAND CHIFFRES  sur 2 lignes	HAUTE		
;********************************************************
TEST_0_9_h	
		;	movfw	DATA_LCD_I2C	
	              	movwf	TEMP_reception
			movf		PCLATH , w		; charger PCLATH
			movwf	PCLATH_temp		; le sauver
			
			movlw 	0x02
			movwf 	PCLATH
						
			movfw	TEMP_reception

CONVERT_PCL_h
			addwf 		PCL , f ; ajouter w  PCL
			
			goto    	ZERO_h
			goto    	UN_h
			goto    	DEUX_h 
			goto    	TROIS_h
			goto    	QUATRE_h
			goto    	CINQ_h
			goto    	SIX_h 
			goto    	SEPT_h
			goto    	HUIT_h
		       	goto    	NEUF_h 
		       
;*****************************************************************************
;			AIGUILLAGE  AFFICHAGE  LCD  GRAPHIQUE
;*****************************************************************************

ZERO_h	movlw	zero_h
		goto 	TRANSFERT_LCD_GRAPHIQUE
UN_h	movlw	un_h
		goto 	TRANSFERT_LCD_GRAPHIQUE
DEUX_h	movlw	deux_h
		goto 	TRANSFERT_LCD_GRAPHIQUE
TROIS_h	movlw	trois_h
		goto 	TRANSFERT_LCD_GRAPHIQUE
QUATRE_h	movlw	quatre_h
		goto 	TRANSFERT_LCD_GRAPHIQUE
CINQ_h	movlw	cinq_h
		goto 	TRANSFERT_LCD_GRAPHIQUE		
SIX_h	movlw	six_h
		goto 	TRANSFERT_LCD_GRAPHIQUE
SEPT_h	movlw	sept_h
		goto 	TRANSFERT_LCD_GRAPHIQUE		
HUIT_h	movlw	huit_h
		goto 	TRANSFERT_LCD_GRAPHIQUE	
NEUF_h	movlw	neuf_h
		goto 	TRANSFERT_LCD_GRAPHIQUE

;********************************************************
;		GRAND CHIFFRES  sur 2 lignes	BASSE		
;********************************************************

TEST_0_9_b	
		;	movfw	DATA_LCD_I2C
		            movwf	TEMP_reception
			movf		PCLATH , w		; charger PCLATH
			movwf	PCLATH_temp		; le sauver
			
			movlw 	0x02
			movwf 	PCLATH
						
			movfw	TEMP_reception

CONVERT_PCL_b
			addwf 		PCL , f ; ajouter w  PCL
			
			goto      	ZERO_b
			goto       	UN_b
			goto    	DEUX_b 
			goto    	TROIS_b
			goto    	QUATRE_b
			goto    	CINQ_b
			goto    	SIX_b 
			goto    	SEPT_b
			goto    	HUIT_b
		       	goto    	NEUF_b 


;*****************************************************************************
;			AIGUILLAGE  AFFICHAGE  LCD  GRAPHIQUE
;*****************************************************************************

ZERO_b	movlw	zero_b
		goto 	TRANSFERT_LCD_GRAPHIQUE
UN_b	movlw	un_b
		goto 	TRANSFERT_LCD_GRAPHIQUE
DEUX_b	movlw	deux_b
		goto 	TRANSFERT_LCD_GRAPHIQUE		
TROIS_b	 movlw	trois_b
		goto 	TRANSFERT_LCD_GRAPHIQUE
QUATRE_b movlw	quatre_b
		goto 	TRANSFERT_LCD_GRAPHIQUE
CINQ_b	movlw	cinq_b
		goto 	TRANSFERT_LCD_GRAPHIQUE
SIX_b	movlw	six_b
		goto 	TRANSFERT_LCD_GRAPHIQUE
SEPT_b	movlw	sept_b
		goto 	TRANSFERT_LCD_GRAPHIQUE
HUIT_b	movlw	huit_b
		goto 	TRANSFERT_LCD_GRAPHIQUE
NEUF_b	movlw	neuf_b
		goto 	TRANSFERT_LCD_GRAPHIQUE
		
;**************************************************************************************************
;* TRANSFERT_LCD_GRAPHIQUE                                                                              *
;**************************************************************************************************

TRANSFERT_LCD_GRAPHIQUE_HIGH   

		movfw	TEMP_EEADR
		
TRANSFERT_LCD_GRAPHIQUE		
		
		bsf     	STATUS,RP1      ;Select Bank 2
		movwf	EEADR  

		bcf     	STATUS,RP1      ;Select Bank 0
		movlw	0x07
		movwf	fin_datas

donnee	
		bsf     	STATUS,RP1      ;Select Bank 2
		movfw	EEADR
		bcf     	STATUS,RP1      ;Select Bank 0		
		call		Rd_Flash

		bsf     	STATUS,RP1     	;Select Bank 2
		movfw	EEDATA		; recup data 

		bcf     	STATUS,RP1      ;Select Bank 0
		call		LCDPUTCHAR	; crit vers LCD 

		decfsz	fin_datas,f
		goto		donnee

		bcf     	STATUS,RP1      ;Select Bank 0
		return
		



	;////////////////////////////////////////////////////////////////////
	;Write character
	;
	;		- Sends character to LCD
	;		- Required character must be in W
	;////////////////////////////////////////////////////////////////////


LCDPUTCHAR	

		return







;	********************************************************************
; 				ROUTINES GESTION BUS I2C                   
;	********************************************************************

;	movlw	B'11110001'	; pour TRISB
;	movwf	TRISB		; ;rb0 en entree       rb1 r rb3 en sortie      rb4 rb7 en entre

;  RB0  |    21  |  E  |    SDA 	 |   SIMULATION I2C SDA
;  RB1  |    22  |  S  |  SCL        	 | SIMULATION I2C SCL


;  RB2  |    23  |  S  |    SCL    	| SIMULATION  I2C  SCL        ESCLAVE    =>    vers le SAA1064   ou autre	 	 	 	| 	 
;  RB3  |    24  |  S   | SDA             | SIMULATION I2C SDA         ESCLAVE    =>    vers le SAA1064   ou autre



i2c_test_SAA1064
		call    i2c_start	; start condition  SCL/SDA
		movlw   0x70        		; "70"--> 0111=slave adress ; 000=device select bus ; 0=write
		goto    i2c_write_byte

;*********************************************************************
;                       ENVOYER LE START-SEQUENCE                    *
;*********************************************************************
;Init data transfer from/to external SAA1064
i2c_start                         ; start condition 

		bsf     	PORTB,3			;  RB3==> SDA -> High
		
		movlw   	B'11110011'		;charge la valeur pour rb0 r rb7  d'ou rb1/rb3 =0 
		tris   		PORTB			;Defini SDA(RB3) et SCL(RB1)   SDA(RB3) passe r "1"
		
		bsf    		PORTB,2			;Clock High     SCLK passe  l'tat haut
		call		DELAY_10us
		bcf     	PORTB,3			;Data start     SDA(RB3) passe  l'tat bas
		goto		clock_low 


;********************************************************************
;                        ENVOYER LE STOP-CONDITION                  *
;********************************************************************
;Stop data transfer from/to external SAA1064
i2c_stop                         ; stop condition 

		bcf     	PORTB,3			;Data start SDA
		movlw   	B'11110011'		;Load value --> RB1 et RB3 en sortie
		tris    		PORTB			;SDA -->en sortie
		nop
		bsf     	PORTB,2			;Clock High	SCL passe  l'tat haut
		call		DELAY_10us
		bsf     	PORTB,3			;Data stop      SDA passe  l'tat haut
nclock_low
		nop
clock_low
		call		DELAY_10us
		bcf     	PORTB,2			;Clock Low	SCL passe  l'tat bas
		call		DELAY_10us		
		return


;********************************************************************
;                        TESTER SI ACK RECU    du SAA1064                     *
;********************************************************************

i2c_test_ack					; le SAA1064 renvoie un ack ou noack ?
		call		i2c_read_bit 	;lecture du bit envoy par le SAA1064

		btfsc		STATUS,C	;si  Carry = 0 ACK reu  
					;selon l'tat de PORTB,3
		goto		i2c_start 	; re test 		
		goto		clock_low	; ok bit ack reu ,on sort


;*********************************************************************
;                      ECRIRE OCTECT vers ESCLAVE I2C             *
;*********************************************************************

;Send a byte stored in W to external  Slave i2c
i2c_write_byte
		movwf   EEDATA2     		;copie w (D0 ou D1 ou datas  envoyer )dans EEDATA2
		movlw   B'11110011' 		;charge la valeur rb0 r rb7 ;   rb2_SCL  /  rb3_SDA =0  config en sortie
		tris    PORTB                	; Configure SDA en sortie

		movlw	0x08			; 8 bits datas  transfrer
		movwf	TEMP			;sauvegarde en ram adr 47

i2c_write_byte_loop

		rlf	EEDATA2,f		;via la carry (STATUS,C)=>bit0
		call	i2c_write_bit_x
		decfsz	TEMP,f			; tant que <0>
		goto	i2c_write_byte_loop	; 8 bits  transfrer

		return

;*********************************************************************
;                      ECRIRE BIT vers SAA1064              *
;*********************************************************************
i2c_write_bit 
		movlw	B'11110011'     	; RB2 et RB3 en sortie
		tris		PORTB           	;SDA en sortie

          ;Actual bit write to RB3 (external EEPROM)
          ;Bit to be written is from carry
			; la data  crire vient de la valeur de C (carry)=> Bit 0 de STATUS
			;*************************************************
i2c_write_bit_x  

			; si carry = 1 alors SDA HIGH  si carry =0  alors SDA LOW
			
		btfss		STATUS,C		;Skip if carry set = 1
			bcf	PORTB,3     	;SDA -> Low
		btfsc		STATUS,C		;Skip if carry no set = 0
			bsf	PORTB,3    	;SDA -> High
		bsf		PORTB,2     		;Clock High

		call		DELAY_15us
		goto		nclock_low

;*********************************************************************
;                      LIRE OCTET Du SAA1064                          *
;*********************************************************************

; Recoit un octet de i2c ,ensuite prsente  NO ACK
; Envoyer ACK (Carry = 0) ou NO ACK (carry = 1)
; le caractere est retourn dans W


;Read a byte from external SAA1064 into EEDATA2
i2c_read_byte 
		movlw    	B'11111011'		;charge valeur,SDA(rb3)
		tris    		PORTB			;Configure SDA en entre
		movlw	0x08
		movwf	TEMP
i2c_read_byte_loop
		call    	i2c_read_bit_x		; charge le bit reu
		rlf     		EEDATA2,f		; stock dans eedata2 
		decfsz	TEMP,f			; dcremente compteur tant que different de 0
		goto		i2c_read_byte_loop	;non, pas 0 alors recommence

		bsf     	STATUS,C		; on force le test de SDA  1,simul le noack, fin de transfert
		return				;oui,retest SDA si 1 ou 0 ,ici sda=1 voir ci-dessus

;*********************************************************************
;                      LIRE BIT Du SAA1064                         *
;*********************************************************************
i2c_read_bit   
		movlw   	B'11111011'		;SDA/rb3 =1 en entre   SCL/rb2 =0 en sortie
		tris    		PORTB       		;SDA en entre

	;Actual bit read from RB3 (external SAA1064)
	;Bit is read into carry

i2c_read_bit_x   
		bsf     	PORTB,2     		;SCL -> High
		call		DELAY_15us
			bsf     STATUS,C	;on suppose un 1 ?
		btfss   	PORTB,3    		;Test SDA si =1 ?
			bcf     STATUS,C	;non dans ce cas , on avait un zero
		goto		clock_low

;********************************************************************
;                        ENVOYER LE ACK    par le pic                        *
;********************************************************************
i2c_pic_ack					; le pic renvoie un ack

		bcf		STATUS,C	; le bit qui sera envoy vaudra " 0 "
		call		i2c_write_bit 
		goto		clock_low	; ok bit ack envoy ,on sort

;********************************************************************
;                        ENVOYER LE NOACK     par le pic                     *
;********************************************************************
i2c_pic_noack					; le pic renvoie un ack

		bsf		STATUS,C	; le bit qui sera envoy vaudra " 1 "
		call		i2c_write_bit 
		goto		clock_low	; ok bit ack envoy ,on sort

;********************************************************************
;                        ENVOYER LE REPEATED START-CONDITION                 *
;********************************************************************
i2c_rstart
		bsf     	PORTB,3			;  RB3==> SDA -> High

		movlw   	B'11110011'		;charge la valeur pour rb0 r rb7  d'ou rb1/rb3 =0 
						;donc rb1/rb3 config en sortie
		tris   		PORTB			;Defini SDA(RB3) et SCL(RB1)   SDA(RB3) passe  "1"

		bsf    		PORTB,2			;Clock High     SCLK passe  l'tat haut
		call		DELAY_15us
		bcf     	PORTB,3			;Data start     SDA(RB3) passe  l'tat bas
		goto		clock_low 


;********************************************************************
;* 				READ EXTERNAL SAA1064                                                                   *
;********************************************************************
;* ADR_SAA1064 : W = Address of SAA1064                                                                *
;* W = Data Read                                                                                  *
;********************************************************************
Read_SAA1064
;		movwf	ADR_SAA1064
       
			; Envoyer start-squence
			; ----------------------
		call    	i2c_stop       	; ligne au repos       
		call    	i2c_start	; start condition  SCL/SDA

			; Envoyer contrle
			; ----------------
		movlw   	0x71        		; "D0"--> 1101=slave adress ; 000=device select bus ; 1=read
		call    	i2c_write_byte	;crit  mot de 8 bits

			; vrifier si OK
			; --------------
		call		i2c_test_ack		;ack reu   ?


		call    	i2c_read_byte	;lecture mot de 8 bits
		movfw	EEDATA2			;charge variable
		movwf	DATA0_SAA1064	;data sauve ===>>>  dans w
		
			; fin de dialogue
			; ---------------
		call		i2c_pic_noack		;le pic renvoie un "noack" ,indique fin de rception.

		call    	i2c_stop		;fin de dialogue

		return

;********************************************************************
;* WRITE EXTERNAL SAA1064                                            *
;********************************************************************
;* EEADRH2:ADR_SAA1064 = Address of SAA1064                           *
;* W = Data Written                                                 *
;********************************************************************
Write_SAA1064

	                bcf     STATUS,RP0      	;Select Bank 0
	
	                 	; Envoyer start-squence
				; ----------------------
	      		call    i2c_stop       ; ligne au repos      
	                call    i2c_start	; start condition  SCL/SDA
	
				; Envoyer contrle
				; ----------------
	
			movlw   0x70        		; "70"--> 0111=slave adress ; 000=device select bus ; 0=write
			call    i2c_write_byte	;crit
	
				; vrifier si OK
				; --------------
			call	i2c_test_ack		;ack reu de l'eeprom ?
			
INSTRUCTION_BYTE
;*****************************
				; envoyer SC SB SA = subaddress bits
				; ---------------
	                	movfw    	SUBADRESS		;subaddress bits
	                	call    	i2c_write_byte	; crit mot de 8 bits
	
				; vrifier si OK
				; --------------
			call	i2c_test_ack		;ack reu de l'eeprom ?
			                			
CONTROL_BYTE
;*************************			
				; envoyer C6 to C0 = control bits
				; ---------------
	               	movf    	CONTROLBYTE,W		;control bits
	                	call    	i2c_write_byte	; crit mot de 8 bits
	
				; vrifier si OK
				; --------------
			call		i2c_test_ack		;ack reu de l'eeprom ?
		
digit1		; envoyer data r ecrire
			; --------------------
	                movf    	DATA1_SAA1064,W		;charge data r ecrire
	                call    i2c_write_byte		;crit mot de 8 bits
	
				; vrifier si OK
				; --------------
			call	i2c_test_ack		;ack reu   ?
				                
digit2			; envoyer data r ecrire
			; --------------------
	               movf    DATA2_SAA1064,W		;charge data r ecrire
	                call    i2c_write_byte		;crit mot de 8 bits
	
				; vrifier si OK
				; --------------
			call	i2c_test_ack		;ack reu   ?
		
digit3			; envoyer data r ecrire
			; --------------------
	            movf    	DATA3_SAA1064,W		;charge data r ecrire
	            call    	i2c_write_byte	;crit mot de 8 bits
	
				; vrifier si OK
				; --------------
		call		i2c_test_ack		;ack reu   ?
;
digit4			; envoyer data r ecrire
			; --------------------
		movf    	DATA4_SAA1064,W		;charge data r ecrire
		call   		 i2c_write_byte	;crit mot de 8 bits
	
				; vrifier si OK
				; --------------
		call		i2c_test_ack		;ack reu   ?		
	
	
		call		i2c_pic_noack			
			; Envoyer stop-squence
			; ----------------------
                	call  i2c_stop	;stop dialogue
		
		return
		




		
;**************************************************************************************************
;* READ FLASH MEMORY                                                                              *
;**************************************************************************************************
;* EEADRH2:w = Address of Memory                                                                  *
;* W = Data Read                                                                                  *
;**************************************************************************************************
Rd_Flash
	                bsf     	STATUS,RP1      	;Select Bank 2
	                movwf   	EEADR
	                bcf     	STATUS,RP1     	 ;Select Bank 0
		     movlw	HIGH(fichier)		 ; adresse haute fichier include
	                addwf   	EEADRH2,W
	                bsf     	STATUS,RP1      	;Select Bank 2
	                movwf   	EEADRH
		    goto	Rd_Flash_Next
	
;******************************************************
;* READ PROGRAM FLASH MEMORY
;******************************************************
;* EEADRH2:EEADR2 = Address of Flash Memory
;* W = Data Read
;******************************************************
Rd_PFlash
	                movf    	EEADR2,W
	                bsf     	STATUS,RP1     	 ;Select Bank 2
	                movwf   	EEADR
	                bcf     	STATUS,RP1     	 ;Select Bank 0
	                movf    	EEADRH2,W
	                bsf     	STATUS,RP1      	;Select Bank 2
	                movwf   	EEADRH
Rd_Flash_Next
	                bsf     	STATUS,RP1      
	                bsf     	STATUS,RP0      	;Select Bank 3
	                bsf     	EECON1,EEPGD
	                bsf     	EECON1,RD
	                nop                    				 ;Any instruc-tions here are ignored as program
	                nop                     					;memory is read in third cycle after BSF EECON1,RD
	                bcf     	STATUS,RP0      	;Select Bank 2
		    movf	EEDATA,W
	
	                incf    	EEADR,F

	                bcf     	STATUS,RP1      	;Select Bank 0
	                btfsc   	STATUS,C		;btfsc   STATUS,Z
	                incf    	EEADRH2,F
		    bcf     	STATUS,RP1      	;Select Bank 0              
		return


   


 
				;;
				;
				;       Programmes de gestion de l'afficheur LCD   GRA-PHIQUE  
				;
			 	;

;Pin Name			 I/O 										Pin Function
;VSS				 - 						Ground (0V)
;VDD				 - 						Logic Supply (+5V)
;C/D;				I						 Register Select: "1" = Command                Register, 0 = Data Register
;RD				I 						Read Select (Active Low) - MPU  T6963C
;WR				I 						Write Select (Active Low) - MPU  T6963C
;CE				I 						Chip Enable (Active Low)
;DB0 				I/O 						Bi-directional Data Bus Line 0
;DB1 				I/O  						Bi-directional Data Bus Line 1
;DB2				 I/O  						Bi-directional Data Bus Line 2
;DB3 				I/O  						Bi-directional Data Bus Line 3
;DB4 				I/O 						 Bi-directional Data Bus Line 4
;DB5 				I/O  						Bi-directional Data Bus Line 5
;DB6 				I/O  						Bi-directional Data Bus Line 6
;DB7 				I/O  						Bi-directional Data Bus Line 7
;,RES				;I 						Reset (Active Low)
;FS1 				I 						Font Select 6x8 font: FS1=H 8x8 font FS1=L
;MD2 				I 						Mode Select 40 columns MD2=H 32 columns MD2=H



						;
						;    T6963C Instruction Set          
						;


;
;Pointer Set
;-------------------------------------------------------------------------------------------------------------------------------------------
;			D7 	D6 	D5 	D4 	D3 	D2 	D1 	D0 	Description			Time
;Pointer Set 	0 	0 	1 	0 	0 	N2 	N1 	N0 				     Status check
;								0 	0 	1 	Cursor Pointer Set
;								0 	1 	0 	Offset Register Set
;								1 	0 	0 	Address Pointer Set
;-------------------------------------------------------------------------------------------------------------------------------------------










;
;Control Word Set Commands
;-------------------------------------------------------------------------------------------------------------------------------------------
;			D7 	D6 	D5 	D4 	D3 	D2 	D1 	D0 	Description			Time
;Control Word 	0 	1 	0 	0 	0 	0 	N1 	N0 				32 x1/fosc
;Set Commands 							0 	0 	Text Home Address Set
;									0 	1 	Text Area Set
;									1 	0 	Graphic Home Address Set
;									1 	1 	Graphic Area Set
;-------------------------------------------------------------------------------------------------------------------------------------------















;
;Mode Set
;-------------------------------------------------------------------------------------------------------------------------------------------
;			D7 	D6 	D5 	D4 	D3 	D2 	D1 	D0 	Description			Time
;Mode Set 		1 	0 	0 	0 	CG 	N2 	N1 	N0 				32 x1/fosc
;							0 				CG ROM Mode
;							1 				CG RAM Mode
;								0 	0 	0 	"OR" Mode
;								0 	0 	1 	"EXOR" Mode
;								0 	1 	1 	"AND" Mode
;								1 	0 	0 	Text only (attribute capability)
;-------------------------------------------------------------------------------------------------------------------------------------------











;
;Display Modes
;-------------------------------------------------------------------------------------------------------------------------------------------
;			D7 	D6 	D5 	D4 	D3 	D2 	D1 	D0 	Description			Time	
;Display Modes 	1 	0 	0 	1 	N3 	N2 	N1 	N0 				           	32 x1/fosc
;							0 				Graphics Off
;							1 				Graphics On
;								0 			Text Off
;								1 			Text On
;									0 		Cursor Off
;									1 		Cursor On
;										0 	Cursor blink Off
;										1 	Cursor blink On
;-------------------------------------------------------------------------------------------------------------------------------------------












										
;
;Cursor Pattern Select
;-------------------------------------------------------------------------------------------------------------------------------------------
;			D7 	D6 	D5 	D4 	D3 	D2 	D1 	D0 	Description						Time										
;Cursor Pattern 	1 	0 	1 	0 	0 	N2 	N1 	N0 	N2~N0: No. of lines for cursor +1 	32 x1/fosc
;Select 							0 	0 	0 	Bottom Line cursor
;								0 	0 	1 	2 line cursor
;								| 	| 	|
;								1 	1 	1 	8 line cursor (block cursor)
;-------------------------------------------------------------------------------------------------------------------------------------------								
								
		
		
		
		
		
		
								
								
;
;Data Auto Read/Write
;-------------------------------------------------------------------------------------------------------------------------------------------
;			D7 	D6 	D5 	D4 	D3 	D2 	D1 	D0 	Description						Time									
;Data Auto 		1 	1 	0 	0 	0 	0 	N1 	N0 								32 x1/fosc
;Read/Write 							0 	0 	Data Auto Write Set
;									0 	1 	Data Auto Read Set
;									1 	0 	Auto reset (Address pointer autoincremented)
;											for continuous rd/wr
;-------------------------------------------------------------------------------------------------------------------------------------------			









								
;
;Data  Read/Write
;-------------------------------------------------------------------------------------------------------------------------------------------
;				D7 	D6 	D5 	D4 	D3 	D2 	D1 	D0 	Description						Time												
;Data Read/Write 	1 	1 	0 	0 	0 	N2 	N1 	N0
;									0 			Address Pointer up/down
;									1 			Address Pointer unchanged
;										0 			Address Pointer up
;										1 		Address Pointer down
;											0 	Data Write
;											1 	Data Read
;-------------------------------------------------------------------------------------------------------------------------------------------											
											
				
				
				
				
				
											
;
;Screen Peeking
;-------------------------------------------------------------------------------------------------------------------------------------------
;				D7 	D6 	D5 	D4 	D3 	D2 	D1 	D0 	Description						Time												
;Screen Peeking 		1 	1 	1 	0 	0 	0 	0 	0 	Read Displayed Data 			Status
;-------------------------------------------------------------------------------------------------------------------------------------------











;
;Screen Copy
;-------------------------------------------------------------------------------------------------------------------------------------------
;				D7 	D6 	D5 	D4 	D3 	D2 	D1 	D0 	Description								Time	
;Screen Copy		1 	1 	1 	0 	1 	0 	0 	0 	Copies 1 line of displayed data whose            Statuscheck
;(Note 3)											address is indicated by the Address
;												Pointer to Graphic RAM area
;-------------------------------------------------------------------------------------------------------------------------------------------









;
;Bit Set/Reset
;-------------------------------------------------------------------------------------------------------------------------------------------
;				D7 	D6 	D5 	D4 	D3 	D2 	D1 	D0 	Description								Time	
;Bit Set/Reset 		1 	1 	1 	1 	N3 	N2 	N1 	N0 	N2~N0 indicates the bit in the pointed		Statuscheck
;												address
;								0 				Bit Reset
;								1 				Bit Set
;									0 	0 	0 	Bit 0 (LSB)
;									0 	0 	1 	Bit 1
;									| 	| 	|
;									1 	1 	1 	Bit 7 (MSB)
;-------------------------------------------------------------------------------------------------------------------------------------------






;2.1 Write data - The data to be written should be set on D0 - 7 and
				;C/\D taken low,
				;/WR taken low 		(/RD should be high)
				;/CE pulsed low for greater than 80ns
;			
;2.2 Read data
				;- C/\D take low,
				;/RD take low (/WR should be high)
				;/CE take low
							;After 150ns read the data on D0-7
				;/CE take high
;
;2.3 Write Command - 		To Write a Command - The command should be set on D0 - 7 and
				;C/\D taken high,
				;/WR taken low (/RD should be high)
				;/CE pulsed low for greater than 80ns
;
;2.4 Read Status -			 To check the Status of the T6963C controller -
				;C/\D take high,
				;/RD take low (/WR should be high)
				;/CE take low
							;After 150ns read the data on D0-7
				;/CE take high
					;Note that there is no such thing as reading an command instruction.







	;************** a delay of 'W' * 200 micro S
			; si w = FF
			; (256 *(1+767+1+2))-1 = (771*256) - 1 = 197375 *260 = 51ms
X_DELAY500 
		MOVWF 	X_DELAY 	;  x fois 200 s	 1  cycle
X_DELAY500_LOOP 
		CALL 	DELAY_200us 	 ; wait 200uS		767 cycles
		DECFSZ 	X_DELAY, F 	 ;			1   cycle
		GOTO 	X_DELAY500_LOOP  ;			2   cycles
		RETURN 			 ;			2   cycles
  
			;************** a 200uS delay @ 15MHz360 X-tal   (201.3s)
DELAY_200us 				;(256*3)-1 = 767 cycles
		clrf	DELAY 		; x 0.26 us =	 199420 ns

DELAY_LOOP 
		DECFSZ 	DELAY, F  		; +1     1 cycle	 
		goto 	DELAY_LOOP  		; +1     2 cycles
		bcf	STATUS,RP0 	;sort avec bank0
		RETURN 				
	
	
		
	org	0x0800
		#include <d:\Fichier Commun\fichier1.asm>

	End








